/*
 * Decompiled with CFR 0.152.
 */
package com.inprise.vbroker.compiler.util;

import com.inprise.vbroker.compiler.util.ErrorReporter;
import com.inprise.vbroker.util.DriverUsage;
import com.inprise.vbroker.util.Version;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Vector;

public abstract class Options {
    public static final String _lineSep = System.getProperty("line.separator");
    public ErrorReporter _ER;

    public Options(ErrorReporter ER) {
        this._ER = ER;
    }

    public void checkForUnusedFlags(String[] flags, boolean[] usageResult) {
        if (usageResult[1]) {
            return;
        }
        for (int i = 0; i < flags.length; ++i) {
            String flag = flags[i];
            if (flag == null || !flag.startsWith("-") || flag.equals("-")) continue;
            if (flag.startsWith("-no_")) {
                flag = "-".concat(String.valueOf(flag.substring(4)));
            }
            if (flag.equals("-version") || flag.equals("-XXX_debug") || flag.equals("-no_XXX_debug") || flag.equals("-strict") || flag.equals("-no_strict") || flag.equals("-warn_all") || flag.equals("-no_warn_all") || flag.equals("-back_compat_mapping")) {
                if (flag.equals("-version")) {
                    this._ER.printUntranslated(Version.java());
                    this._ER.printUntranslated(Version.platform());
                    usageResult[1] = true;
                }
                flags[i] = null;
                continue;
            }
            usageResult[0] = true;
            this._ER.warn("Comp.Tools.unusedFlag", flags[i]);
            flags[i] = null;
        }
    }

    protected String[] cleanupArg(String[] flags, int i) {
        Hashtable eliminatedMap;
        String newFlag;
        String[] deprecatedGluedList = this.deprecatedGluedList();
        if (deprecatedGluedList != null) {
            for (int j = 0; j < deprecatedGluedList.length; ++j) {
                if (!flags[i].startsWith(deprecatedGluedList[j]) || flags[i].length() <= deprecatedGluedList[j].length() || flags[i].equals("-export_skel")) continue;
                this._ER.warn("Comp.Tools.deprecatedGluedStyle", flags[i]);
                String flag = deprecatedGluedList[j];
                String arg = flags[i].substring(deprecatedGluedList[j].length());
                String[] tmp = new String[flags.length + 1];
                System.arraycopy(flags, 0, tmp, 0, i);
                tmp[i] = flag;
                tmp[i + 1] = arg;
                System.arraycopy(flags, i + 1, tmp, i + 2, flags.length - i - 1);
                flags = tmp;
                break;
            }
        }
        String flag = flags[i];
        Hashtable deprecatedMap = this.deprecatedMap();
        if (deprecatedMap != null && (newFlag = (String)((Dictionary)deprecatedMap).get(flag)) != null) {
            if (newFlag.startsWith("-XXX")) {
                this._ER.warn("Comp.Tools.deprecatedFlagWithHiddenReplacement", new Object[]{flag});
            } else {
                this._ER.warn("Comp.Tools.deprecatedFlag", new Object[]{flag, newFlag});
            }
            flags[i] = flag = newFlag;
        }
        if ((eliminatedMap = this.eliminatedMap()) != null && ((Dictionary)eliminatedMap).get(flag) != null) {
            this._ER.warn("Comp.Tools.eliminatedFlag", flag);
            flags[i] = null;
        }
        return flags;
    }

    protected String[] deprecatedGluedList() {
        return null;
    }

    protected Hashtable deprecatedMap() {
        return null;
    }

    protected Hashtable eliminatedMap() {
        return null;
    }

    protected String getArg(String[] flags, int i) {
        if (flags.length <= i + 1) {
            this._ER.error("Comp.Tools.missingArgument", flags[i]);
            throw new IllegalArgumentException("expected command-line argument at location ".concat(String.valueOf(i)));
        }
        String arg = flags[i + 1];
        if (arg == null || arg.startsWith("-")) {
            this._ER.error("Comp.Tools.missingArgument", flags[i]);
            throw new IllegalArgumentException("expected command-line argument at location ".concat(String.valueOf(i)));
        }
        flags[i + 1] = null;
        flags[i] = null;
        if (arg.startsWith("\\-")) {
            return arg.substring(1);
        }
        return arg;
    }

    public abstract String[] getUsage();

    protected final String[] getUsage(Options[] contribOptions, String[] usageStrings) {
        int i;
        Vector<String> usage = new Vector<String>();
        String[] strs = this.getUsage();
        for (i = 0; i < strs.length; ++i) {
            String str = strs[i];
            if (usage.contains(str)) continue;
            usage.addElement(str);
        }
        if (contribOptions != null) {
            for (i = 0; i < contribOptions.length; ++i) {
                strs = contribOptions[i].getUsage();
                for (int j = 0; j < strs.length; ++j) {
                    String str = strs[j];
                    if (usage.contains(str)) continue;
                    usage.addElement(str);
                }
            }
        }
        usage.addElement("Comp.Tools.CLflag.help");
        usage.addElement("Comp.Tools.CLflag.version");
        if (usageStrings != null) {
            for (i = 0; i < usageStrings.length; ++i) {
                String str = usageStrings[i];
                if (usage.contains(str)) continue;
                usage.addElement(str);
            }
        }
        Object[] ret = new String[usage.size()];
        usage.copyInto(ret);
        return ret;
    }

    public String[] parse(String[] flags, boolean[] usageResult) {
        if (usageResult[1]) {
            return flags;
        }
        block9: for (int i = 0; i < flags.length; ++i) {
            boolean invert = false;
            String flag = flags[i];
            if (flag == null || !flag.startsWith("-")) continue;
            if ((flags = this.cleanupArg(flags, i)) == null) {
                usageResult[1] = true;
                usageResult[0] = true;
                return flags;
            }
            flag = flags[i];
            if (flag == null) continue;
            if ((flag = flag.substring(1)).startsWith("no_")) {
                invert = true;
                flag = flag.substring(3);
            }
            if (flag.equals("")) continue;
            try {
                switch (flag.charAt(0)) {
                    case 'X': {
                        if (flag.equals("XXX_debug")) {
                            this._ER._verbose = true;
                            break;
                        }
                        if (!flag.equals("XXX_authors")) continue block9;
                        this._ER.untranslatedMessage("VisiBroker 4.0 Compiler Suite authors:");
                        this._ER.untranslatedMessage("  Vijay Natarajan");
                        this._ER.untranslatedMessage("  Tim A. Wagner");
                        flags[i] = null;
                        break;
                    }
                    case '?': {
                        if (!flag.equals("?")) continue block9;
                        usageResult[0] = true;
                        usageResult[1] = true;
                        String[] stringArray = flags;
                        return stringArray;
                    }
                    case 'h': {
                        if (!flag.equals("h") && !flag.equals("help")) continue block9;
                        usageResult[0] = true;
                        usageResult[1] = true;
                        String[] stringArray = flags;
                        return stringArray;
                    }
                    case 'u': {
                        if (!flag.equals("usage")) continue block9;
                        usageResult[0] = true;
                        usageResult[1] = true;
                        String[] stringArray = flags;
                        return stringArray;
                    }
                    case 'v': {
                        if (!flag.equals("version")) continue block9;
                        this.version();
                        usageResult[0] = false;
                        usageResult[1] = false;
                        String[] stringArray = flags;
                        return stringArray;
                    }
                }
                continue;
            }
            catch (IllegalArgumentException e) {
                usageResult[1] = true;
                usageResult[0] = true;
                String[] stringArray = flags;
                return stringArray;
            }
        }
        return flags;
    }

    public final void printUsage(Options[] contribOptions, String[] usageStrings) {
        String tmp = String.valueOf(new StringBuffer(String.valueOf(_lineSep)).append("  ").append(this._ER.getMesg("Comp.Tools.driverOptions")));
        String[] myFlags = this.getUsage(contribOptions, usageStrings);
        for (int i = 0; i < myFlags.length; ++i) {
            tmp = String.valueOf(tmp).concat(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(_lineSep)).append("  ").append(this._ER.getMesg(myFlags[i])))));
        }
        this._ER.add("Comp.Tools.usage", new Object[]{tmp});
        DriverUsage.printUsage(this._ER.getToolName());
    }

    protected abstract void version();
}

